/*
 * Decompiled with CFR 0.152.
 */
package entities.missiles.sona;

import core.states.GameState;
import entities.Entity;
import entities.creatures.CreatureEntity;
import entities.creatures.EnemyCreatureEntity;
import entities.creatures.player.SonaEntity;
import entities.missiles.MissileEntity;
import util.Config;

public final class SonaAbilityQEntity
extends MissileEntity {
    private boolean used = false;

    public SonaAbilityQEntity(SonaEntity parent, GameState game, int x, int y) {
        super(parent, game, "missiles/sona/abilityQ", x, y);
        this.dy = this.moveSpeed = (double)(-Math.min(Config.get(Config.sonaAbilityQProjectileSpeed) + Config.get(Config.sonaAbilityQProjectileSpeedPerLevel) * game.getLevel(), Config.get(Config.sonaAbilityQProjectileSpeedCap)));
    }

    @Override
    public void collidedWith(Entity other) {
        if (this.used) {
            return;
        }
        if (other instanceof EnemyCreatureEntity) {
            this.game.removeEntity(this);
            if (((CreatureEntity)other).hasEffectType("spellshield")) {
                ((CreatureEntity)other).removeEffectByType("spellshield");
            } else {
                ((CreatureEntity)other).damage(this, Config.get(Config.sonaAbilityQDamage) + Config.get(Config.sonaAbilityQDamagePerLevel) * this.game.getLevel());
            }
            this.used = true;
        }
    }
}

